
//Home Page Project Filter

document.addEventListener('DOMContentLoaded', function () {
    // Initialize Isotope
    var $grid = document.querySelector('.project-content');
    var iso = new Isotope($grid, {
        itemSelector: '.project-content-item',
        layoutMode: 'fitRows'
    });

    // Filter items on button click
    var filters = document.querySelectorAll('.project-filters button');
    filters.forEach(function (button) {
        button.addEventListener('click', function () {
            var filterValue = this.getAttribute('data-filter');
            iso.arrange({ filter: filterValue });
        });
    });
});





// Home Page News and Updates
$(document).ready(function() {
    $("#testimonial-slider").owlCarousel({
        items: 3, // Default items for desktop
        loop: true, // To make sure the carousel loops infinitely
        margin: 10, // Margin between items
        nav: true, // Show next/prev navigation
        navText: ["", ""], // Text for navigation buttons
        autoplay: true, // Enable autoPlay
        autoplayTimeout: 5000, // 5 seconds autoPlay interval
        autoplayHoverPause: true, // Pause on hover
        responsive: {
            0: {
                items: 1 // Items for mobile devices
            },
            600: {
                items: 2 // Items for tablets
            },
            1000: {
                items: 3 // Items for desktops
            }
        }
    });
});
